#include <stdio.h>

#define Vin 0.5
#define timeFinal 5.0


void run_simulation(double R, double C, double stepsize, int testNum);

int main() {
	run_simulation(10000, 0.0002, 0.1, 1);

	run_simulation(5000, 0.0001, 0.1, 2);

	run_simulation(10000, 0.0002, 0.5, 3);

	run_simulation(5000, 0.0001, 0.5, 4);

	return 0;
}

/*
Function to simulate an RC circuit with voltage across C as output voltage
Pass in resistance, capacitance, time step size, and test number
*/
void run_simulation(double R, double C, double stepsize, int testNum) {
	double Vc = 0.0;
	double time = 0.0;

	double tau = R * C;

	printf("Test number %d: R=%.0f, C=%.0f, Step=.2f, Tau=%.2f \n", testNum, R, C, stepsize, tau);

	printf("Time (s) \t Voltage (V)\n");

	printf("%.2f \t\t %.5f\n", time, Vc);

	// loop until time = timeFinal
	while (time < timeFinal) {
		double newVc = Vc + (stepsize / tau) * (Vin - Vc);
		Vc = newVc;
		time += stepsize;

		printf("%.2f \t\t %.5f\n", time, Vc);
	}
	printf("\n");
}